import sys
import pysam
from Bio.Seq import reverse_complement
from Bio import SeqIO


library = sys.argv[1]


def parse_mappings(bamfile):
    alignments = []
    current = -1
    for alignment in bamfile:
        qname = alignment.qname
        assert qname.startswith("seq_")
        number = int(qname[4:])
        if number != current:
            yield current, alignments
            current = number
            alignments = []
        alignments.append(alignment)
    yield current, alignments


def parse_sequences(filename):
    print("Reading", filename)
    records = SeqIO.parse(filename, 'fasta')
    for record in records:
        qname = record.id
        assert qname.startswith("seq_")
        number = int(qname[4:])
        sequence = str(record.seq)
        yield number, sequence


filename = "seqlist.bam"
print("Reading", filename)
bamfile = pysam.AlignmentFile(filename)
mappings = parse_mappings(bamfile)
sequences = parse_sequences("seqlist.fa")

filename = "%s.bam" % library
print("Writing", filename)

output = pysam.AlignmentFile(filename, 'wb', template=bamfile) 

filename = "%s.index.txt" % library

current_mapping_number = -1
current_sequence_number = -1
print("Reading", filename)
handle = open(filename)
for line in handle:
    seqname, unique_seqname = line.split()
    assert unique_seqname.startswith("seq_")
    number = int(unique_seqname[4:])
    if current_mapping_number < number:
        for current_mapping_number, alignments in mappings:
            if current_mapping_number >= number:
                break
        else:  # reached end of mapping file without finding sequence
            break
    while current_sequence_number < number:
        current_sequence_number, sequence = next(sequences)
    assert current_sequence_number == number
    if current_mapping_number == number:
        for alignment in alignments:
            alignment.qname = seqname
            if not alignment.is_secondary:
                if alignment.is_reverse:
                    alignment.query_sequence = reverse_complement(sequence)
                else:
                    alignment.query_sequence = sequence
            output.write(alignment)

output.close()
handle.close()
bamfile.close()
